var ipsVSEData = {
	"sections": {
		"body": {
			"body": {
				"title": "Body",
				"selector": "body",
				"background": {
					"color": "fcfcfc"
				},
				"font": {
					"color": "353C41"
				},
				"settings": {
					"background": "page_background",
					"color": "text_color"
				}
			},
			"lightText": {
				"title": "Light text",
				"selector": ".ipsType_light",
				"font": {
					"color": "8D9AA6"
				},
				"settings": {
					"font": "text_light"
				}
			},
			"link": {
				"title": "Link color",
				"selector": "a",
				"font": {
					"color": "3D6594"
				},
				"settings": {
					"font": "link_color"
				}
			},
			"linkHover": {
				"title": "Link hover color",
				"selector": "a:hover",
				"font": {
					"color": "4588C5"
				},
				"settings": {
					"font": "link_hover_color"
				}
			},
			"footer": {
				"title": "Footer links color",
				"selector": "#ipsLayout_footer a, #ipsLayout_footer p",
				"font": {
					"color": "353C41"
				},
				"settings": {
					"font": "footer_links"
				}
			}
		},
		"header": {
			"appBar": {
				"title": "Main navigation",
				"selector": "#elMobileNav",
				"background": {
					"color": "375476"
				},
				"settings": {
					"background": "main_nav"
				}
			},
			"appBarFont": {
				"title": "Main navigation font",
				"selector": ".ipsNavBar_primary > ul > li > a",
				"font": {
					"color": "FFFFFF"
				},
				"settings": {
					"font": "main_nav_font"
				}
			},
			"mainNavTab": {
				"title": "Active navigation tab",
				"selector": ".ipsNavBar_primary > ul > li.ipsNavBar_active > a, .ipsNavBar_primary:not( .ipsNavBar_noSubBars ) > ul:before, .ipsNavBar_secondary",
				"background": {
					"color": "FFFFFF"
				},
				"settings": {
					"background": "main_nav_tab"
				}
			},
			"mainNavTabFont": {
				"title": "Active navigation font",
				"selector": ".ipsNavBar_primary > ul > li.ipsNavBar_active > a, .ipsNavBar_secondary > li > a, .ipsNavBar_secondary > li > a:hover, .ipsNavBar_secondary > li.ipsNavBar_active a",
				"font": {
					"color": "353C41"
				},
				"settings": {
					"font": "main_nav_tab_font"
				}
			},
			"headerBar": {
				"title": "Header",
				"selector": "#ipsLayout_header > header",
				"background": {
					"color": "3D6594"
				},
				"settings": {
					"background": "header"
				}
			},
			"siteName": {
				"title": "Site name text",
				"selector": "#elSiteTitle",
				"font": {
					"color": "ffffff"
				}
			},
			"mobileBack": {
				"title": "Mobile back button",
				"selector": "#elMobileBreadcrumb, #elMobileBreadcrumb:before",
				"background": {
					"color": "E8E9EB"
				},
				"settings": {
					"background": "mobile_back"
				}
			},
			"mobileBackFont": {
				"title": "Mobile back button font",
				"selector": "#elMobileBreadcrumb a",
				"font": {
					"color": "353C41"
				},
				"settings": {
					"font": "mobile_back_font"
				}
			}
		},
		"buttons": {
			"normalButton": {
				"title": "Normal button",
				"selector": ".ipsApp .ipsButton_normal",
				"background": {
					"color": "478F79"
				},
				"font": {
					"color": "ffffff"
				},
				"settings": {
					"background": "normal_button",
					"font": "normal_button_font"
				}
			},
			"primaryButton": {
				"title": "Primary button",
				"selector": ".ipsApp .ipsButton_primary",
				"background": {
					"color": "3E4148"
				},
				"font": {
					"color": "ffffff"
				},
				"settings": {
					"background": "primary_button",
					"font": "primary_button_font"
				}
			},
			"importantButton": {
				"title": "Important button",
				"selector": ".ipsApp .ipsButton_important",
				"background": {
					"color": "478F79"
				},
				"font": {
					"color": "ffffff"
				},
				"settings": {
					"background": "important_button",
					"font": "important_button_font"
				}
			},
			"alternateButton": {
				"title": "Alternate button",
				"selector": ".ipsApp .ipsButton_alternate",
				"background": {
					"color": "3E4148"
				},
				"font": {
					"color": "ffffff"
				},
				"settings": {
					"background": "alternate_button",
					"font": "alternate_button_font"
				}
			},
			"lightButton": {
				"title": "Light button",
				"selector": ".ipsApp .ipsButton_light",
				"background": {
					"color": "E5E5E5"
				},
				"font": {
					"color": "333333"
				},
				"settings": {
					"background": "light_button",
					"font": "light_button_font"
				}
			},
			"veryLightButton": {
				"title": "Very light button",
				"selector": ".ipsApp .ipsButton_veryLight",
				"background": {
					"color": "ffffff"
				},
				"font": {
					"color": "333333"
				},
				"settings": {
					"background": "very_light_button",
					"font": "very_light_button_font"
				}
			},
			"buttonBar": {
				"title": "Button Bar",
				"selector": ".ipsButtonBar",
				"background": {
					"color": "FFFFFF"
				},
				"settings": {
					"background": "button_bar"
				}
			}
		},
		"backgrounds": {
			"areaBackground": {
				"title": "Area background",
				"selector": ".ipsAreaBackground",
				"background": {
					"color": "E6E8EB"
				},
				"settings": {
					"background": "area_background"
				}
			},
			"areaBackgroundLight": {
				"title": "Light area background",
				"selector": ".ipsAreaBackground_light",
				"background": {
					"color": "F8F8F8"
				},
				"settings": {
					"background": "area_background_light"
				}
			},
			"areaBackgroundReset": {
				"title": "Reset area background",
				"selector": ".ipsAreaBackground_reset",
				"background": {
					"color": "ffffff"
				},
				"settings": {
					"background": "area_background_reset"
				}
			},
			"areaBackgroundDark": {
				"title": "Dark area background",
				"selector": ".ipsAreaBackground_dark",
				"background": {
					"color": "353C41"
				},
				"settings": {
					"background": "area_background_dark"
				}
			}
		},
		"other": {
			"itemStatus": {
				"title": "Item status badge",
				"selector": ".ipsItemStatus.ipsItemStatus_large",
				"background": {
					"color": "353C41"
				},
				"settings": {
					"background": "item_status"
				}
			},
			"tabBar": {
				"title": "Tab bar background",
				"selector": ".ipsTabs",
				"background": {
					"color": "3D6594"
				},
				"settings": {
					"background": "tab_background"
				}
			},
			"highlightedContent": {
				"title": "Highlighted posts",
				"selector": ".ipsComment_highlighted.ipsBox:not(.ipsBox_transparent):not(.ipsModerated):not(.ipsComment_selected), .ipsComment_highlighted:not(.ipsBox_transparent):not(.ipsModerated):not(.ipsComment_selected) .ipsAreaBackground_reset, .ipsComment_highlighted:not(.ipsBox_transparent):not(.ipsModerated):not(.ipsComment_selected)",
				"background": {
					"color": "FFFEFA"
				},
				"settings": {
					"background": "post_highlight"
				}
			},
			"sectionTitle": {
				"title": "Section title bar",
				"selector": ".ipsType_sectionTitle",
				"background": {
					"color": "EBEDF0"
				},
				"settings": {
					"background": "section_title"
				}
			},
			"sectionTitleFont": {
				"title": "Section title bar font",
				"selector": "a.ipsType_sectionTitle, .ipsType_sectionTitle a",
				"font": {
					"color": "828e99"
				},
				"settings": {
					"font": "section_title_font"
				}
			},
			"profileHeader": {
				"title": "Default profile header",
				"selector": "#elProfileHeader",
				"background": {
					"color": "353C41"
				},
				"settings": {
					"background": "profile_header"
				}
			},
			"widgetTitleBar": {
				"title": "Widget title bar",
				"selector": ".ipsWidget.ipsWidget_vertical .ipsWidget_title",
				"background": {
					"color": "EBEDF0"
				},
				"font": {
					"color": "828E99"
				},
				"settings": {
					"background": "widget_title_bar",
					"font": "widget_title_font"
				}
			},
			"mentions": {
				"title": "Mentions",
				"selector": "a[data-mentionid]",
				"background": {
					"color": "3D6594"
				},
				"settings": {
					"background": "mentions"
				}
			},
			"notification": {
				"title": "Notification bubble",
				"selector": ".ipsApp .ipsNotificationCount",
				"background": {
					"color": "B63F3F"
				},
				"settings": {
					"background": "notification_bubble"
				}
			}
		}
	}
};

var colorizer = {
	primaryColor: {
		"body": [ 'background' ],
		"link": [ 'font' ],
		"appBar": [ 'background' ],
		"mainNavTab": [ 'background' ],
		"headerBar": [ 'background' ],
		"normalButton": [ 'background' ],
		"primaryButton": [ 'background' ],
		"alternateButton": [ 'background' ],
		"sectionTitle": [ 'background' ],
		"sectionTitleFont": [ 'font' ],
		"areaBackgroundDark": [ 'background' ],
		"profileHeader": [ 'background' ],
		"link": [ 'font' ],
		"widgetTitleBar": [ 'background', 'font' ],
		"buttonBar": [ 'background' ],
		"tabBar": [ 'background' ],
		"itemStatus": [ 'background' ]
	},
	secondaryColor: {
		"linkHover": [ 'font' ],
		"importantButton": [ 'background' ],
		"notification": [ 'background' ],
		"mentions": [ 'background' ]
	},
	tertiaryColor: {
		"areaBackground": [ 'background' ],
		"areaBackgroundLight": [ 'background' ],
		"areaBackgroundReset": [ 'background' ],
		"highlightedContent": [ 'background' ],
		"mobileBack": [ 'background' ],
		"mobileBackFont": [ 'font' ]
	},
	textColor: {
		"body": [ 'font' ],
		"lightText": [ 'font' ],
		"mainNavTabFont": [ 'font' ],
		"footer": [ 'font' ]
	},
	startColors: {
		"primaryColor": "3D6594",
		"secondaryColor": "D66723",
		"tertiaryColor": "f3f3f3",
		"textColor": "3E4148"
	}
};